/******************************************************************************
*
* Freescale(TM) and the Freescale logo are trademarks of Freescale Semiconductor, Inc.
* All other product or service names are the property of their respective owners.
* (C) Freescale Semiconductor, Inc. 2007
*
* THIS SOURCE CODE IS CONFIDENTIAL AND PROPRIETARY AND MAY NOT
* BE USED OR DISTRIBUTED WITHOUT THE WRITTEN PERMISSION OF
* Freescale Semiconductor, Inc.
*
* Filename:     $Source: /u/OSEK/src/axe/cfg/axecfg.h,v $
* Author:       $Author: b09107 $
* Revision:     $Revision: 1.15 $
*
* Functions:
*
* History:      Use the CVS command rlog to display revision history
*
* Description:  The AXE Scheduler configuration definitions
*
* Notes:  
*
******************************************************************************/

#ifndef AXE_CFG_H
#define AXE_CFG_H

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* Maximum number of tasks */
#define AXE_MAX_NUM_OF_TASKS    16

/* Maximum task's priority */
#define AXE_MAX_PRIORITY        7

/* Maximum number of semaphores */
#define AXE_MAX_NUM_OF_SEM      3

/* Activates(1) the debugging facilitate fields */
#define AXE_DEBUG               1

/* Enable Task ID cheking */
#define AXE_CHECK_ID            1

/* Task name string length
   including termination symbol */
#define AXE_MAX_TASK_NAME_LEN   8

/* Growth of stack
   if AXE_STACK_GROWTH < 0
       stack grows to low addresses
   else
       stack grows to high addresses */
#define AXE_STACK_GROWTH       -1

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* AXE_CFG_H */

